<?php if (!defined('VB_ENTRY')) die('Access denied.');
/*======================================================*\
|| ############################################### ||
|| # ----------------vBSmart Team - vBulletin 4.0.1Version ------------------------- # ||
|| # Copyright ©2000-2010 vBulletin Solutions Inc. All Rights Reserved. ||
|| #      This file may not be redistributed in whole or significant part    . # ||
|| ############################################### ||
\*======================================================*/

/**
 * vBCms Navbar
 * Builds the vBCms links for display in the navbar.
 *
 * @package vBulletin
 * @author vBulletin Development Team
 * @version $Revision: 31871 $
 * @since $Date: 2009-08-25 16:54:54 +0100 (Tue, 25 Aug 2009) $
 * @copyright vBulletin Solutions Inc.
 */
class vBCms_NavBar
{
	/*Constants=====================================================================*/

	/**
	 * Global cache event.
	 * Use when a section is deleted or published.
	 */
	const GLOBAL_CACHE_EVENT = 'vbcms_nav_global';
	const GLOBAL_SECTION_CACHE_EVENT = 'sections_updated';

	/*Properties====================================================================*/

	/**
	 * The navbar link view
	 *
	 * @var vB_View
	 */
	public static $view;
	private static $cache_ttl = 10;

	/**
	 * A prefix for all cache references.
	 *
	 * @var string
	 */
	public static $cache_prefix = 'vbcms_nav_';


	/*View==========================================================================*/

	/**
	 * Prepares the navbar view so that it can be fetched and rendered.
	 * Note: Forcing the cache to be ignored is useful if the subnav has just been
	 * updated.
	 *
	 * @param vBCms_Item_Content $node			- The current node
	 * @param bool $refresh						- Forces the cache to be ignored and the view to be rebuilt.
	 */
	public static function prepareNavBar($node = false, $refresh = false)
	{
		// Normalize node
		$node = ($node ?  $node : 1);

		if (!$node instanceof vBCms_Item_Content)
		{
			$node = new vBCms_Item_Content($node, vBCms_Item_Content::INFO_NAVIGATION);
		}

		$cache_key = self::getHash($node);

		if ($refresh OR !$navnodes = vB_Cache::instance()->read($cache_key))
		{
			if (!$navnodes = $node->getNavigationNodes())
			{
				return false;
			}
			// get collection
			$collection = new vBCms_Collection_Content($navnodes, vBCms_Item_Content::INFO_NODE | vBCms_Item_Content::INFO_PARENTS);

			// check count
			if (!$collection->isValid())
			{
				return false;
			}

			// set original ids as keys
			$navnodes = array_flip($navnodes);

			// remap order
			foreach ($collection AS $navnode)
			{
				$navnodes[$navnode->getNodeId()] = $navnode;
			}
			unset($collection);

			// remove unfound entries
			foreach ($navnodes AS $id => $navnode)
			{
				if (!$navnode instanceof vBCms_Item_Content)
				{
					unset($navnodes[$id]);
				}
			}
			// write cache
			vB_Cache::instance()->write(
				$cache_key,
				$navnodes,
				self::$cache_ttl,
				array(
					self::getCacheEventId($node->getNavigationNode()),
					self::GLOBAL_CACHE_EVENT,
					self::GLOBAL_SECTION_CACHE_EVENT
				)
			);

		}

		// create navlinks for published nodes
		$links = array();
		$route = new vBCms_Route_Content();

		foreach ($navnodes AS $navnode)
		{
			if ($navnode->isPublished())
			{
				$route->node = $navnode->getUrlSegment();
				$links[] = array(
					'title' => $navnode->getTitle(),
					'url' => $route->getCurrentUrl()
				);
			}
		}


		if (!self::$view OR $refresh)
		{
			self::$view = new vB_View('vbcms_navbar_link');
			self::$view->links = $links;
		}

	}


	/**
	 * Fetches the prepared nabar view.
	 *
	 * @return vB_View							- The navbar link view
	 */
	public static function renderView()
	{
		if (self::$view)
		{
			vB::$vbulletin->options['selectednavtab'] = 'vbcms';
			return self::$view->render();
		}
		else
		{
			return false;
		}
	}

	/********* Get a hash so we can cache the data
	 *
	 ********/
	protected static function getHash($node)
	{
		$navnode = $node->getNavigationNode();
		$context = new vB_Context(self::$cache_prefix . $navnode, array($navnode, vB::$vbulletin->userinfo['usergroupid'], vB::$vbulletin->userinfo['membergroupids']));
		return strval($context);
	}


	/**
	 * Fetches a consistent event id for a given node's navbar.
	 *
	 * @param int $nodeid						- The nodeid being cached.
	 * @return string
	 */
	public static function getCacheEventId($nodeid)
	{
		return array(self::$cache_prefix . $nodeid);

	}
}


/*======================================================================*\
|| ####################################################################
|| # Downloaded: 17:48, Tue Jan 12th 2010
|| # SVN: $Revision: 31871 $
|| ####################################################################
\*======================================================================*/